-- Custom Stats for No Man's Sky - MultiTool - DEFAULT
-- Mod_Version = "0.1.1"

-- You can change the stats you want below
-- Default stats are indicated as comments next to the variables
-- HD means HyperDrive
-- Dmg means Damage
-- MT has been added in front of Alien and Royal multitools variables to avoid conflicts with ships


---------------------------------
------ WEAPONBASESTATSDATA ------
---------------------------------

--- ALIEN ---

MT_AlienC_Dmg_Max = "15" -- "15"
MT_AlienC_Dmg_Min = "10" -- "10"
MT_AlienC_Mining_Max = "5" -- "5"
MT_AlienC_Mining_Min = "0" -- "0"
MT_AlienC_Scan_Max = "25" -- "25"
MT_AlienC_Scan_Min = "20" -- "20"

MT_AlienB_Dmg_Max = "20" -- "20"
MT_AlienB_Dmg_Min = "15" -- "15"
MT_AlienB_Mining_Max = "10" -- "10"
MT_AlienB_Mining_Min = "5" -- "5"
MT_AlienB_Scan_Max = "35" -- "35"
MT_AlienB_Scan_Min = "30" -- "30"

MT_AlienA_Dmg_Max = "25" -- "25"
MT_AlienA_Dmg_Min = "20" -- "20"
MT_AlienA_Mining_Max = "15" -- "15"
MT_AlienA_Mining_Min = "10" -- "10"
MT_AlienA_Scan_Max = "45" -- "45"
MT_AlienA_Scan_Min = "40" -- "40"

MT_AlienS_Dmg_Max = "35" -- "35"
MT_AlienS_Dmg_Min = "25" -- "25"
MT_AlienS_Mining_Max = "20" -- "20"
MT_AlienS_Mining_Min = "15" -- "15"
MT_AlienS_Scan_Max = "60" -- "60"
MT_AlienS_Scan_Min = "50" -- "50"

--- PISTOL ---

MT_PistolC_Dmg_Max = "0" -- "0"
MT_PistolC_Dmg_Min = "0" -- "0"
MT_PistolC_Mining_Max = "10" -- "10"
MT_PistolC_Mining_Min = "5" -- "5"
MT_PistolC_Scan_Max = "20" -- "20"
MT_PistolC_Scan_Min = "10" -- "10"

MT_PistolB_Dmg_Max = "0" -- "0"
MT_PistolB_Dmg_Min = "0" -- "0"
MT_PistolB_Mining_Max = "15" -- "15"
MT_PistolB_Mining_Min = "10" -- "10"
MT_PistolB_Scan_Max = "30" -- "30"
MT_PistolB_Scan_Min = "25" -- "25"

MT_PistolA_Dmg_Max = "0" -- "0"
MT_PistolA_Dmg_Min = "0" -- "0"
MT_PistolA_Mining_Max = "20" -- "20"
MT_PistolA_Mining_Min = "15" -- "15"
MT_PistolA_Scan_Max = "40" -- "40"
MT_PistolA_Scan_Min = "35" -- "35"

MT_PistolS_Dmg_Max = "0" -- "0"
MT_PistolS_Dmg_Min = "0" -- "0"
MT_PistolS_Mining_Max = "35" -- "35"
MT_PistolS_Mining_Min = "20" -- "20"
MT_PistolS_Scan_Max = "50" -- "50"
MT_PistolS_Scan_Min = "45" -- "45"

--- PRISTINE ---

MT_PristineC_Dmg_Max = "5" -- "5"
MT_PristineC_Dmg_Min = "0" -- "0"
MT_PristineC_Mining_Max = "10" -- "10"
MT_PristineC_Mining_Min = "5" -- "5"
MT_PristineC_Scan_Max = "50" -- "50"
MT_PristineC_Scan_Min = "40" -- "40"

MT_PristineB_Dmg_Max = "10" -- "10"
MT_PristineB_Dmg_Min = "5" -- "5"
MT_PristineB_Mining_Max = "20" -- "20"
MT_PristineB_Mining_Min = "10" -- "10"
MT_PristineB_Scan_Max = "70" -- "70"
MT_PristineB_Scan_Min = "60" -- "60"

MT_PristineA_Dmg_Max = "15" -- "15"
MT_PristineA_Dmg_Min = "10" -- "10"
MT_PristineA_Mining_Max = "25" -- "25"
MT_PristineA_Mining_Min = "20" -- "20"
MT_PristineA_Scan_Max = "90" -- "90"
MT_PristineA_Scan_Min = "80" -- "80"

MT_PristineS_Dmg_Max = "25" -- "25"
MT_PristineS_Dmg_Min = "15" -- "15"
MT_PristineS_Mining_Max = "30" -- "30"
MT_PristineS_Mining_Min = "25" -- "25"
MT_PristineS_Scan_Max = "100" -- "100"
MT_PristineS_Scan_Min = "100" -- "100"

--- RIFLE ---

MT_RifleC_Dmg_Max = "5" -- "5"
MT_RifleC_Dmg_Min = "0" -- "0"
MT_RifleC_Mining_Max = "0" -- "0"
MT_RifleC_Mining_Min = "0" -- "0"
MT_RifleC_Scan_Max = "5" -- "5"
MT_RifleC_Scan_Min = "0" -- "0"

MT_RifleB_Dmg_Max = "10" -- "10"
MT_RifleB_Dmg_Min = "5" -- "5"
MT_RifleB_Mining_Max = "0" -- "0"
MT_RifleB_Mining_Min = "0" -- "0"
MT_RifleB_Scan_Max = "10" -- "10"
MT_RifleB_Scan_Min = "5" -- "5"

MT_RifleA_Dmg_Max = "15" -- "15"
MT_RifleA_Dmg_Min = "10" -- "10"
MT_RifleA_Mining_Max = "0" -- "0"
MT_RifleA_Mining_Min = "0" -- "0"
MT_RifleA_Scan_Max = "15" -- "15"
MT_RifleA_Scan_Min = "10" -- "10"

MT_RifleS_Dmg_Max = "20" -- "20"
MT_RifleS_Dmg_Min = "15" -- "15"
MT_RifleS_Mining_Max = "0" -- "0"
MT_RifleS_Mining_Min = "0" -- "0"
MT_RifleS_Scan_Max = "20" -- "20"
MT_RifleS_Scan_Min = "15" -- "15"

--- ROYAL ---

MT_RoyalC_Dmg_Max = "5" -- "5"
MT_RoyalC_Dmg_Min = "0" -- "0"
MT_RoyalC_Mining_Max = "10" -- "10"
MT_RoyalC_Mining_Min = "5" -- "5"
MT_RoyalC_Scan_Max = "50" -- "50"
MT_RoyalC_Scan_Min = "40" -- "40"

MT_RoyalB_Dmg_Max = "10" -- "10"
MT_RoyalB_Dmg_Min = "5" -- "5"
MT_RoyalB_Mining_Max = "20" -- "20"
MT_RoyalB_Mining_Min = "10" -- "10"
MT_RoyalB_Scan_Max = "70" -- "70"
MT_RoyalB_Scan_Min = "60" -- "60"

MT_RoyalA_Dmg_Max = "15" -- "15"
MT_RoyalA_Dmg_Min = "10" -- "10"
MT_RoyalA_Mining_Max = "25" -- "25"
MT_RoyalA_Mining_Min = "20" -- "20"
MT_RoyalA_Scan_Max = "90" -- "90"
MT_RoyalA_Scan_Min = "80" -- "80"

MT_RoyalS_Dmg_Max = "25" -- "25"
MT_RoyalS_Dmg_Min = "15" -- "15"
MT_RoyalS_Mining_Max = "30" -- "30"
MT_RoyalS_Mining_Min = "25" -- "25"
MT_RoyalS_Scan_Max = "100" -- "100"
MT_RoyalS_Scan_Min = "100" -- "100"


-- Don't change code past this line unless you know what you are doing. --

BaseStatChanges =
{
  {
  "WeaponBaseStatsData",
    {
      {
      "Alien",
        {
          {
          "C",
            {
              {"WEAPON_DAMAGE",
                { MT_AlienC_Dmg_Max, MT_AlienC_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_AlienC_Mining_Max, MT_AlienC_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_AlienC_Scan_Max, MT_AlienC_Scan_Min, }
              },
            }
          },
          {
          "B",
            {
              {"WEAPON_DAMAGE",
                { MT_AlienB_Dmg_Max, MT_AlienB_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_AlienB_Mining_Max, MT_AlienB_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_AlienB_Scan_Max, MT_AlienB_Scan_Min, }
              },
            }
          },
          {
          "A",
            {
              {"WEAPON_DAMAGE",
                { MT_AlienA_Dmg_Max, MT_AlienA_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_AlienA_Mining_Max, MT_AlienA_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_AlienA_Scan_Max, MT_AlienA_Scan_Min, }
              },
            }
          },
          {
          "S",
            {
              {"WEAPON_DAMAGE",
                { MT_AlienS_Dmg_Max, MT_AlienS_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_AlienS_Mining_Max, MT_AlienS_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_AlienS_Scan_Max, MT_AlienS_Scan_Min, }
              },
            }
          },
        }
      },
      {
      "Pistol",
        {
          {
          "C",
            {
              {"WEAPON_DAMAGE",
                { MT_PistolC_Dmg_Max, MT_PistolC_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_PistolC_Mining_Max, MT_PistolC_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_PistolC_Scan_Max, MT_PistolC_Scan_Min, }
              },
            }
          },
          {
          "B",
            {
              {"WEAPON_DAMAGE",
                { MT_PistolB_Dmg_Max, MT_PistolB_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_PistolB_Mining_Max, MT_PistolB_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_PistolB_Scan_Max, MT_PistolB_Scan_Min, }
              },
            }
          },
          {
          "A",
            {
              {"WEAPON_DAMAGE",
                { MT_PistolA_Dmg_Max, MT_PistolA_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_PistolA_Mining_Max, MT_PistolA_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_PistolA_Scan_Max, MT_PistolA_Scan_Min, }
              },
            }
          },
          {
          "S",
            {
              {"WEAPON_DAMAGE",
                { MT_PistolS_Dmg_Max, MT_PistolS_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_PistolS_Mining_Max, MT_PistolS_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_PistolS_Scan_Max, MT_PistolS_Scan_Min, }
              },
            }
          },
        }
      },
      {
      "Pristine",
        {
          {
          "C",
            {
              {"WEAPON_DAMAGE",
                { MT_PristineC_Dmg_Max, MT_PristineC_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_PristineC_Mining_Max, MT_PristineC_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_PristineC_Scan_Max, MT_PristineC_Scan_Min, }
              },
            }
          },
          {
          "B",
            {
              {"WEAPON_DAMAGE",
                { MT_PristineB_Dmg_Max, MT_PristineB_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_PristineB_Mining_Max, MT_PristineB_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_PristineB_Scan_Max, MT_PristineB_Scan_Min, }
              },
            }
          },
          {
          "A",
            {
              {"WEAPON_DAMAGE",
                { MT_PristineA_Dmg_Max, MT_PristineA_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_PristineA_Mining_Max, MT_PristineA_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_PristineA_Scan_Max, MT_PristineA_Scan_Min, }
              },
            }
          },
          {
          "S",
            {
              {"WEAPON_DAMAGE",
                { MT_PristineS_Dmg_Max, MT_PristineS_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_PristineS_Mining_Max, MT_PristineS_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_PristineS_Scan_Max, MT_PristineS_Scan_Min, }
              },
            }
          },
        }
      },
      {
      "Rifle",
        {
          {
          "C",
            {
              {"WEAPON_DAMAGE",
                { MT_RifleC_Dmg_Max, MT_RifleC_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_RifleC_Mining_Max, MT_RifleC_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_RifleC_Scan_Max, MT_RifleC_Scan_Min, }
              },
            }
          },
          {
          "B",
            {
              {"WEAPON_DAMAGE",
                { MT_RifleB_Dmg_Max, MT_RifleB_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_RifleB_Mining_Max, MT_RifleB_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_RifleB_Scan_Max, MT_RifleB_Scan_Min, }
              },
            }
          },
          {
          "A",
            {
              {"WEAPON_DAMAGE",
                { MT_RifleA_Dmg_Max, MT_RifleA_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_RifleA_Mining_Max, MT_RifleA_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_RifleA_Scan_Max, MT_RifleA_Scan_Min, }
              },
            }
          },
          {
          "S",
            {
              {"WEAPON_DAMAGE",
                { MT_RifleS_Dmg_Max, MT_RifleS_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_RifleS_Mining_Max, MT_RifleS_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_RifleS_Scan_Max, MT_RifleS_Scan_Min, }
              },
            }
          },
        }
      },
      {
      "Royal",
        {
          {
          "C",
            {
              {"WEAPON_DAMAGE",
                { MT_RoyalC_Dmg_Max, MT_RoyalC_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_RoyalC_Mining_Max, MT_RoyalC_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_RoyalC_Scan_Max, MT_RoyalC_Scan_Min, }
              },
            }
          },
          {
          "B",
            {
              {"WEAPON_DAMAGE",
                { MT_RoyalB_Dmg_Max, MT_RoyalB_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_RoyalB_Mining_Max, MT_RoyalB_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_RoyalB_Scan_Max, MT_RoyalB_Scan_Min, }
              },
            }
          },
          {
          "A",
            {
              {"WEAPON_DAMAGE",
                { MT_RoyalA_Dmg_Max, MT_RoyalA_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_RoyalA_Mining_Max, MT_RoyalA_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_RoyalA_Scan_Max, MT_RoyalA_Scan_Min, }
              },
            }
          },
          {
          "S",
            {
              {"WEAPON_DAMAGE",
                { MT_RoyalS_Dmg_Max, MT_RoyalS_Dmg_Min, }
              },
              {"WEAPON_MINING",
                { MT_RoyalS_Mining_Max, MT_RoyalS_Mining_Min, }
              },
              {"WEAPON_SCAN",
                { MT_RoyalS_Scan_Max, MT_RoyalS_Scan_Min, }
              },
            }
          },
        }
      },
    }
  },
}


-- File Settings --
FileName    = "CustomStats_0.1.1_MT_DEFAULT.pak"
ModAuthor   = "Elsia"
LuaAuthor   = "Elsia"
ModMaintenance = "Probably Elsia"
Description = "Change base stats for multitools."
NMS_Version = "3.99"


-- File Source --
FileSource1 = "METADATA/REALITY/TABLES/INVENTORYTABLE.MBIN"

NMS_MOD_DEFINITION_CONTAINER = 
{
  ["MOD_FILENAME"]    = FileName,
  ["MOD_AUTHOR"]      = ModAuthor,
  ["LUA_AUTHOR"]      = LuaAuthor,
  ["MOD_MAINTENANCE"] = ModMaintenance,
  ["MOD_DESCRIPTION"] = Description,
  ["NMS_VERSION"]     = NMS_Version,
  ["MODIFICATIONS"]   =
  {
    {
      ["MBIN_CHANGE_TABLE"] = 
      { 
        {
          ["MBIN_FILE_SOURCE"]  = FileSource1,
          ["EXML_CHANGE_TABLE"] = 
          {
            -- InventoryTable
          }
        },
      }
    },
  }
}

local InventoryTable = NMS_MOD_DEFINITION_CONTAINER["MODIFICATIONS"][1]["MBIN_CHANGE_TABLE"][1]["EXML_CHANGE_TABLE"]

for i = 1, #BaseStatChanges do
  local Category = BaseStatChanges[i][2]
  for j = 1, #Category do
    local ObjectType = Category[j][1]
    local ObjectStat = Category[j][2]
    for k = 1, #ObjectStat do
      local ObjectClass = ObjectStat[k][1]
      local Change = ObjectStat[k][2]
      for l = 1, #Change do
        local StatID = Change[l][1]
        local Min = Change[l][2][1]
        local Max = Change[l][2][2]

        InventoryTable[#InventoryTable+1] =
        {
          ["SPECIAL_KEY_WORDS"]  = {ObjectType, "GcInventoryGenerationBaseStatData.xml", ObjectClass, "GcInventoryGenerationBaseStatClassData.xml", "BaseStatID", StatID},
          ["VALUE_CHANGE_TABLE"] = 
          {
            {"Min", Min},
            {"Max", Max}
          }
        }

      end
    end
  end
end